# Guia de Uso com Docker

Este guia explica como executar o N8N Notificador usando Docker e Docker Compose.

## Requisitos

- Docker instalado no seu sistema
- Docker Compose instalado no seu sistema
- Conhecimento básico de Docker

## Executando com Docker Compose

O método mais simples para executar o aplicativo é usando Docker Compose, que já está configurado no arquivo `docker-compose.yml`.

### Passo 1: Configurar as variáveis de ambiente

Edite o arquivo `docker-compose.yml` e atualize as variáveis de ambiente:

```yaml
environment:
  - FIREBASE_SERVER_KEY=SUA_CHAVE_FIREBASE_AQUI
  - DEBUG_MODE=true
```

### Passo 2: Iniciar o contêiner

```bash
docker-compose up -d
```

Isso irá construir a imagem Docker e iniciar o contêiner em segundo plano.

### Passo 3: Acessar o aplicativo

O aplicativo estará disponível em:

```
http://localhost:8080
```

## Construindo e Executando Manualmente com Docker

Se preferir, você pode construir e executar o contêiner manualmente:

### Passo 1: Construir a imagem

```bash
docker build -t n8n-notifier .
```

### Passo 2: Executar o contêiner

```bash
docker run -d -p 8080:80 \
  -v $(pwd)/device_tokens.json:/var/www/html/device_tokens.json \
  -v $(pwd)/webhook_log.txt:/var/www/html/webhook_log.txt \
  -e FIREBASE_SERVER_KEY=SUA_CHAVE_FIREBASE_AQUI \
  -e DEBUG_MODE=true \
  --name n8n-notifier \
  n8n-notifier
```

## Usando com HTTPS

Para usar HTTPS com Docker, você tem algumas opções:

### Opção 1: Usar um proxy reverso (recomendado)

Configure um proxy reverso como Nginx ou Traefik na frente do contêiner:

#### Exemplo com Traefik:

Adicione as seguintes labels ao serviço no `docker-compose.yml`:

```yaml
services:
  n8n-notifier:
    # ... outras configurações ...
    labels:
      - "traefik.enable=true"
      - "traefik.http.routers.n8n-notifier.rule=Host(`seu-dominio.com`)"
      - "traefik.http.routers.n8n-notifier.entrypoints=websecure"
      - "traefik.http.routers.n8n-notifier.tls.certresolver=myresolver"
```

#### Exemplo com Nginx:

Crie um arquivo de configuração Nginx:

```nginx
server {
    listen 443 ssl;
    server_name seu-dominio.com;

    ssl_certificate /path/to/cert.pem;
    ssl_certificate_key /path/to/key.pem;

    location / {
        proxy_pass http://n8n-notifier:80;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

### Opção 2: Montar certificados SSL no contêiner

Você pode modificar o Dockerfile para incluir suporte a SSL e montar seus certificados:

1. Modifique o Dockerfile:

```dockerfile
# Adicione após a linha "RUN a2enmod rewrite headers"
RUN a2enmod ssl
COPY ./ssl/apache-selfsigned.crt /etc/ssl/certs/
COPY ./ssl/apache-selfsigned.key /etc/ssl/private/
COPY ./ssl/apache-ssl.conf /etc/apache2/sites-available/
RUN a2ensite apache-ssl
```

2. Crie um arquivo de configuração SSL para o Apache:

```apache
<VirtualHost *:443>
    ServerName seu-dominio.com
    DocumentRoot /var/www/html
    
    SSLEngine on
    SSLCertificateFile /etc/ssl/certs/apache-selfsigned.crt
    SSLCertificateKeyFile /etc/ssl/private/apache-selfsigned.key
    
    <Directory /var/www/html>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/error.log
    CustomLog ${APACHE_LOG_DIR}/access.log combined
</VirtualHost>
```

## Integrando com n8n no Docker

O arquivo `docker-compose.yml` inclui um serviço n8n comentado. Para executar o n8n junto com o notificador:

1. Descomente o serviço n8n no arquivo `docker-compose.yml`
2. Inicie os contêineres:

```bash
docker-compose up -d
```

O n8n estará disponível em:

```
http://localhost:5678
```

### Configurando o webhook no n8n

Ao configurar o webhook no n8n, use a URL interna do Docker:

```
http://n8n-notifier/index.php
```

Ou, se estiver acessando de fora da rede Docker:

```
http://localhost:8080/index.php
```

## Gerenciando Logs

Para ver os logs do contêiner:

```bash
docker-compose logs -f n8n-notifier
```

Ou, se estiver executando manualmente:

```bash
docker logs -f n8n-notifier
```

## Atualizando o Aplicativo

Para atualizar o aplicativo:

1. Pare o contêiner:

```bash
docker-compose down
```

2. Puxe as alterações mais recentes (se estiver usando Git):

```bash
git pull
```

3. Reconstrua e inicie o contêiner:

```bash
docker-compose up -d --build
```

## Solução de Problemas

### Problema: O contêiner inicia mas o aplicativo não está acessível

Verifique se o contêiner está em execução:

```bash
docker ps
```

Verifique os logs do contêiner:

```bash
docker logs n8n-notifier
```

### Problema: Erros de permissão

Se houver erros de permissão nos arquivos de log ou tokens:

```bash
docker exec -it n8n-notifier bash
chmod 777 /var/www/html/device_tokens.json /var/www/html/webhook_log.txt
```

### Problema: Não recebe notificações

Verifique se a chave do Firebase está configurada corretamente:

```bash
docker exec -it n8n-notifier bash
cat /var/www/html/index.php | grep firebase_server_key
```

## Backup dos Dados

Para fazer backup dos dados do aplicativo:

```bash
docker cp n8n-notifier:/var/www/html/device_tokens.json ./backup/
docker cp n8n-notifier:/var/www/html/webhook_log.txt ./backup/
```

## Restaurando Dados

Para restaurar dados de backup:

```bash
docker cp ./backup/device_tokens.json n8n-notifier:/var/www/html/
docker cp ./backup/webhook_log.txt n8n-notifier:/var/www/html/