# Guia de Instalação no cPanel

Este guia fornece instruções para instalar o N8N Notificador em um servidor com cPanel.

## Requisitos

- Hospedagem com cPanel
- PHP 7.2 ou superior
- Suporte a HTTPS (para PWA e notificações push)
- Conta no Firebase para notificações push

## Passo 1: Fazer Upload dos Arquivos

1. Faça login no seu cPanel
2. Vá para o Gerenciador de Arquivos
3. Navegue até a pasta `public_html` ou a pasta do subdomínio onde deseja instalar o aplicativo
4. Crie uma nova pasta chamada `n8n-notifier` (ou o nome que preferir)
5. Entre na pasta criada
6. Clique em "Upload" no topo da página
7. Faça upload de todos os arquivos do projeto
   - Você pode fazer upload de um arquivo ZIP e depois extraí-lo usando o cPanel

## Passo 2: Configurar o Firebase

1. Acesse o [Console do Firebase](https://console.firebase.google.com/)
2. Crie um novo projeto ou use um existente
3. Adicione um aplicativo web ao projeto
4. Copie as configurações do Firebase

5. No cPanel, edite o arquivo `firebase-config.js`:
   - Substitua as configurações de exemplo pelas suas configurações reais:
   ```javascript
   const firebaseConfig = {
     apiKey: "SUA_API_KEY_REAL",
     authDomain: "seu-projeto-real.firebaseapp.com",
     projectId: "seu-projeto-real",
     storageBucket: "seu-projeto-real.appspot.com",
     messagingSenderId: "SEU_MESSAGING_SENDER_ID_REAL",
     appId: "SEU_APP_ID_REAL"
   };
   ```

6. Obtenha a chave do servidor FCM:
   - No console do Firebase, vá para "Project settings" > "Cloud Messaging"
   - Copie a "Server key"

7. No cPanel, edite o arquivo `index.php`:
   - Substitua a chave do servidor FCM:
   ```php
   $config = [
       'debug' => true,
       'log_file' => 'webhook_log.txt',
       'firebase_server_key' => 'SUA_CHAVE_FIREBASE_REAL', // Substitua aqui
       'allowed_origins' => ['*']
   ];
   ```

## Passo 3: Criar os Ícones

Você tem duas opções para criar os ícones:

### Opção 1: Usar a ferramenta online

1. Acesse o site [PWA Builder](https://www.pwabuilder.com/imageGenerator) ou [App Icon Generator](https://appicon.co/)
2. Faça upload de uma imagem e gere os ícones nos tamanhos necessários
3. Faça upload dos ícones para a pasta `icons` no cPanel

### Opção 2: Usar a ferramenta incluída

1. Abra o arquivo `create-default-icon.html` em seu navegador
2. Personalize o ícone conforme desejado
3. Clique em "Baixar Ícone" para salvar o ícone como PNG
4. Faça upload do ícone para a pasta `icons` no cPanel, renomeando-o para os tamanhos necessários:
   - icon-72x72.png
   - icon-96x96.png
   - icon-128x128.png
   - icon-144x144.png
   - icon-152x152.png
   - icon-192x192.png
   - icon-384x384.png
   - icon-512x512.png

## Passo 4: Configurar Permissões

1. No cPanel, vá para o Gerenciador de Arquivos
2. Navegue até a pasta do aplicativo
3. Crie dois arquivos vazios:
   - `device_tokens.json`
   - `webhook_log.txt`
4. Clique com o botão direito em cada arquivo e selecione "Permissões"
5. Defina as permissões para 666 (rw-rw-rw-) para ambos os arquivos

## Passo 5: Testar a Instalação

1. Acesse seu site pelo navegador:
   ```
   https://seu-dominio.com/n8n-notifier/
   ```
2. Você deve ver a página principal do aplicativo
3. Clique em "Ativar Notificações" para permitir notificações push
4. Para testar o webhook, acesse:
   ```
   https://seu-dominio.com/n8n-notifier/test-webhook.php
   ```

## Passo 6: Configurar o n8n

1. Acesse sua instância do n8n
2. Crie um novo fluxo de trabalho
3. Importe o arquivo `n8n-workflow-example.json` ou crie um fluxo manualmente
4. Atualize a URL do webhook para apontar para o seu domínio:
   ```
   https://seu-dominio.com/n8n-notifier/index.php
   ```
5. Ative o fluxo de trabalho

## Solução de Problemas

### Verificar Logs

Se encontrar problemas, verifique o arquivo `webhook_log.txt` no cPanel para ver os logs do aplicativo.

### Problemas com Permissões

Se encontrar erros de permissão:
1. No cPanel, vá para o Gerenciador de Arquivos
2. Navegue até a pasta do aplicativo
3. Selecione todos os arquivos
4. Clique em "Permissões"
5. Defina as permissões para 644 (rw-r--r--) para arquivos
6. Defina as permissões para 755 (rwxr-xr-x) para pastas
7. Defina as permissões para 666 (rw-rw-rw-) para `device_tokens.json` e `webhook_log.txt`

### Problemas com HTTPS

Certifique-se de que seu domínio tem um certificado SSL válido. No cPanel:
1. Vá para "SSL/TLS Status"
2. Verifique se seu domínio tem um certificado válido
3. Se não tiver, use "Let's Encrypt SSL" para instalar um certificado gratuito

### Problemas com o PHP

Verifique a versão do PHP:
1. No cPanel, vá para "PHP Version"
2. Certifique-se de que está usando PHP 7.2 ou superior
3. Ative as extensões necessárias: json, curl, mbstring, xml

## Manutenção

### Backup Regular

Faça backup regular dos seus arquivos:
1. No cPanel, vá para "Backup"
2. Gere um backup completo ou parcial
3. Baixe o backup para seu computador

### Atualizações

Para atualizar o aplicativo:
1. Faça backup dos arquivos `device_tokens.json` e `webhook_log.txt`
2. Faça upload dos novos arquivos
3. Restaure os arquivos de backup