# Guia de Instalação em VPS

Este guia fornece instruções detalhadas para instalar o N8N Notificador em um servidor VPS.

## Requisitos do Servidor

- Sistema operacional: Ubuntu 20.04 ou superior / Debian 10 ou superior
- Memória RAM: Mínimo 1GB
- Espaço em disco: Mínimo 10GB
- Acesso root ou sudo

## Passo 1: Preparar o Servidor

Conecte-se ao seu servidor VPS via SSH:

```bash
ssh usuario@seu-servidor-ip
```

Atualize o sistema:

```bash
sudo apt update
sudo apt upgrade -y
```

## Passo 2: Fazer Upload dos Arquivos

Você pode fazer upload dos arquivos de duas maneiras:

### Opção 1: Usando SCP

No seu computador local:

```bash
scp -r ./n8n-notifier usuario@seu-servidor-ip:/tmp/
```

No servidor:

```bash
sudo mkdir -p /var/www/html/n8n-notifier
sudo cp -r /tmp/n8n-notifier/* /var/www/html/n8n-notifier/
```

### Opção 2: Usando Git

No servidor:

```bash
cd /var/www/html/
sudo git clone https://seu-repositorio/n8n-notifier.git
```

## Passo 3: Executar o Script de Instalação

Torne o script de instalação executável:

```bash
cd /var/www/html/n8n-notifier
sudo chmod +x install.sh
```

Execute o script:

```bash
sudo ./install.sh
```

O script instalará:
- Apache
- PHP e extensões necessárias
- Configurará o site no Apache

## Passo 4: Configurar o Firebase

1. Acesse o [Console do Firebase](https://console.firebase.google.com/)
2. Crie um novo projeto ou use um existente
3. Adicione um aplicativo web ao projeto
4. Copie as configurações do Firebase

Edite o arquivo `firebase-config.js`:

```bash
sudo nano /var/www/html/n8n-notifier/firebase-config.js
```

Substitua as configurações de exemplo pelas suas configurações reais:

```javascript
const firebaseConfig = {
  apiKey: "SUA_API_KEY_REAL",
  authDomain: "seu-projeto-real.firebaseapp.com",
  projectId: "seu-projeto-real",
  storageBucket: "seu-projeto-real.appspot.com",
  messagingSenderId: "SEU_MESSAGING_SENDER_ID_REAL",
  appId: "SEU_APP_ID_REAL"
};
```

Obtenha a chave do servidor FCM:
1. No console do Firebase, vá para "Project settings" > "Cloud Messaging"
2. Copie a "Server key"

Edite o arquivo `index.php`:

```bash
sudo nano /var/www/html/n8n-notifier/index.php
```

Substitua a chave do servidor FCM:

```php
$config = [
    'debug' => true,
    'log_file' => 'webhook_log.txt',
    'firebase_server_key' => 'SUA_CHAVE_FIREBASE_REAL', // Substitua aqui
    'allowed_origins' => ['*']
];
```

## Passo 5: Configurar HTTPS (Obrigatório para PWA e Notificações)

Instale o Certbot para Let's Encrypt:

```bash
sudo apt install certbot python3-certbot-apache -y
```

Obtenha um certificado SSL:

```bash
sudo certbot --apache -d seu-dominio.com
```

Siga as instruções na tela para configurar o certificado.

## Passo 6: Criar os Ícones

Você precisa criar ícones para o PWA. Você pode usar ferramentas online como:
- [PWA Builder](https://www.pwabuilder.com/imageGenerator)
- [App Icon Generator](https://appicon.co/)

Faça upload dos ícones para a pasta `/var/www/html/n8n-notifier/icons/` com os nomes corretos:
- icon-72x72.png
- icon-96x96.png
- icon-128x128.png
- icon-144x144.png
- icon-152x152.png
- icon-192x192.png
- icon-384x384.png
- icon-512x512.png

## Passo 7: Configurar Permissões

Configure as permissões corretas:

```bash
sudo chown -R www-data:www-data /var/www/html/n8n-notifier
sudo chmod -R 755 /var/www/html/n8n-notifier
sudo touch /var/www/html/n8n-notifier/device_tokens.json
sudo touch /var/www/html/n8n-notifier/webhook_log.txt
sudo chmod 777 /var/www/html/n8n-notifier/device_tokens.json
sudo chmod 777 /var/www/html/n8n-notifier/webhook_log.txt
```

## Passo 8: Testar a Instalação

Acesse seu site pelo navegador:

```
https://seu-dominio.com/n8n-notifier/
```

Você deve ver a página principal do aplicativo. Clique em "Ativar Notificações" para permitir notificações push.

Para testar o webhook, acesse:

```
https://seu-dominio.com/n8n-notifier/test-webhook.php
```

## Passo 9: Configurar o n8n

1. Acesse sua instância do n8n
2. Crie um novo fluxo de trabalho
3. Importe o arquivo `n8n-workflow-example.json` ou crie um fluxo manualmente
4. Atualize a URL do webhook para apontar para o seu domínio
5. Ative o fluxo de trabalho

## Solução de Problemas

### Verificar Logs do Apache

```bash
sudo tail -f /var/log/apache2/error.log
```

### Verificar Logs do Aplicativo

```bash
sudo tail -f /var/www/html/n8n-notifier/webhook_log.txt
```

### Problemas com Permissões

Se você encontrar erros de permissão:

```bash
sudo chown -R www-data:www-data /var/www/html/n8n-notifier
sudo chmod -R 755 /var/www/html/n8n-notifier
sudo chmod 777 /var/www/html/n8n-notifier/device_tokens.json
sudo chmod 777 /var/www/html/n8n-notifier/webhook_log.txt
```

### Problemas com HTTPS

Verifique a configuração do SSL:

```bash
sudo apache2ctl -t
```

Reinicie o Apache:

```bash
sudo systemctl restart apache2
```

## Segurança Adicional

Para aumentar a segurança do seu servidor:

### Configurar Firewall

```bash
sudo apt install ufw -y
sudo ufw allow ssh
sudo ufw allow http
sudo ufw allow https
sudo ufw enable
```

### Configurar Fail2Ban

```bash
sudo apt install fail2ban -y
sudo systemctl enable fail2ban
sudo systemctl start fail2ban
```

### Desativar o Modo de Depuração

Após confirmar que tudo está funcionando, desative o modo de depuração:

```bash
sudo nano /var/www/html/n8n-notifier/index.php
```

Altere:

```php
$config = [
    'debug' => false,
    // ...
];
```

## Manutenção

### Backup Regular

Configure backups regulares:

```bash
sudo apt install rsync -y
```

Crie um script de backup:

```bash
sudo nano /usr/local/bin/backup-n8n-notifier.sh
```

Conteúdo do script:

```bash
#!/bin/bash
BACKUP_DIR="/var/backups/n8n-notifier"
DATE=$(date +%Y-%m-%d)
mkdir -p $BACKUP_DIR
rsync -av --delete /var/www/html/n8n-notifier/ $BACKUP_DIR/$DATE/
find $BACKUP_DIR -type d -mtime +7 -exec rm -rf {} \;
```

Torne o script executável:

```bash
sudo chmod +x /usr/local/bin/backup-n8n-notifier.sh
```

Adicione ao cron:

```bash
sudo crontab -e
```

Adicione a linha:

```
0 2 * * * /usr/local/bin/backup-n8n-notifier.sh
```

### Atualizações de Segurança

Configure atualizações automáticas de segurança:

```bash
sudo apt install unattended-upgrades -y
sudo dpkg-reconfigure -plow unattended-upgrades