# N8N Notificador

Um aplicativo web PHP que recebe webhooks do n8n e envia notificações push para dispositivos móveis. Este aplicativo pode ser instalado como um Progressive Web App (PWA) em dispositivos iOS e Android.

## Funcionalidades

- Recebe webhooks do n8n ou qualquer outra plataforma
- Envia notificações push para dispositivos móveis (iOS e Android)
- Funciona como um Progressive Web App (PWA)
- Pode ser instalado em dispositivos móveis
- Funciona offline após a primeira visita

## Requisitos

- Servidor web com PHP 7.2 ou superior
- HTTPS (obrigatório para notificações push e PWA)
- Conta no Firebase para o Firebase Cloud Messaging (FCM)

## Instalação

1. Faça o upload de todos os arquivos para o seu servidor web
2. Configure o Firebase Cloud Messaging (FCM)
3. Atualize a chave do servidor FCM no arquivo `index.php`
4. Crie a pasta `icons` e adicione os ícones necessários
5. Acesse o aplicativo pelo navegador

### Configuração do Firebase Cloud Messaging (FCM)

1. Acesse o [Console do Firebase](https://console.firebase.google.com/)
2. Crie um novo projeto ou use um existente
3. Vá para "Project settings" > "Cloud Messaging"
4. Copie a "Server key"
5. Cole a chave no arquivo `index.php` na variável `$config['firebase_server_key']`

### Criação dos ícones

Você precisa criar ícones nos seguintes tamanhos:
- 72x72
- 96x96
- 128x128
- 144x144
- 152x152
- 192x192
- 384x384
- 512x512

Coloque todos os ícones na pasta `icons` com os nomes correspondentes (ex: `icon-72x72.png`).

## Configuração do n8n

Para enviar notificações do n8n, você precisa configurar um nó HTTP Request:

1. Adicione um nó "HTTP Request" ao seu fluxo de trabalho
2. Configure o método como "POST"
3. Defina a URL como `https://seu-dominio.com/index.php`
4. Defina o corpo da requisição como JSON com a seguinte estrutura:

```json
{
  "title": "Título da notificação",
  "message": "Corpo da mensagem da notificação",
  "data": {
    "workflow_id": "123",
    "event_type": "novo_pedido",
    "custom_field": "valor personalizado"
  }
}
```

## Testando o aplicativo

Você pode testar o aplicativo usando o arquivo `test-webhook.php`:

1. Acesse `https://seu-dominio.com/n8n-notifier/test-webhook.php`
2. O script enviará um webhook de teste para o aplicativo
3. Se tudo estiver configurado corretamente, você receberá uma notificação no seu dispositivo

## Instalando o PWA em dispositivos móveis

### iOS (Safari)

1. Abra o site no Safari
2. Toque no ícone de compartilhamento
3. Selecione "Adicionar à Tela de Início"
4. Confirme o nome e toque em "Adicionar"

### Android (Chrome)

1. Abra o site no Chrome
2. Toque no menu (três pontos)
3. Selecione "Adicionar à tela inicial" ou "Instalar aplicativo"
4. Confirme a instalação

## Estrutura de arquivos

- `index.php` - Arquivo principal que recebe webhooks e gerencia notificações
- `app.html` - Interface do usuário para ativar notificações
- `service-worker.js` - Service Worker para notificações push e funcionalidade offline
- `manifest.json` - Manifesto do PWA
- `test-webhook.php` - Script para testar o envio de webhooks
- `device_tokens.json` - Armazena os tokens dos dispositivos (criado automaticamente)
- `webhook_log.txt` - Arquivo de log (criado automaticamente)
- `icons/` - Pasta com os ícones do aplicativo

## Personalização

Você pode personalizar o aplicativo editando os seguintes arquivos:

- `app.html` - Para alterar a interface do usuário
- `manifest.json` - Para alterar o nome, cores e outras configurações do PWA
- `index.php` - Para alterar a lógica de processamento de webhooks

## Segurança

Para aumentar a segurança, considere:

1. Adicionar autenticação para o webhook (token de API)
2. Limitar origens permitidas no CORS
3. Implementar validação adicional dos dados recebidos
4. Usar HTTPS com certificado válido

## Solução de problemas

### As notificações não estão sendo recebidas

1. Verifique se o Service Worker está registrado corretamente
2. Verifique se a chave do servidor FCM está correta
3. Verifique os logs do navegador para erros
4. Verifique o arquivo `webhook_log.txt` para erros no servidor

### O PWA não está sendo instalado

1. Verifique se o site está sendo servido via HTTPS
2. Verifique se todos os ícones estão presentes
3. Verifique se o manifesto está correto
4. Verifique os logs do navegador para erros

## Instalação no cPanel

Se você está usando cPanel como painel de controle do seu servidor web, siga o guia específico para instalação no cPanel:

[Guia de Instalação no cPanel](GUIA-INSTALACAO-CPANEL.md)

Esta é a opção mais simples para quem utiliza hospedagem compartilhada com cPanel, pois não requer acesso SSH ou configurações avançadas de servidor.

## Licença

Este projeto é distribuído sob a licença MIT.