<?php
/**
 * Script para testar o envio de webhooks para o sistema de notificações
 * 
 * Este script simula o envio de um webhook do n8n para o sistema de notificações.
 * Você pode usá-lo para testar se o sistema está funcionando corretamente.
 */

// URL do webhook (altere para o seu domínio)
$webhookUrl = 'http://localhost/n8n-notifier/index.php';

// Dados do webhook (simula os dados que seriam enviados pelo n8n)
$webhookData = [
    'title' => 'Teste de Notificação',
    'message' => 'Esta é uma notificação de teste enviada em ' . date('d/m/Y H:i:s'),
    'data' => [
        'workflow_id' => '12345',
        'event_type' => 'test',
        'timestamp' => time()
    ]
];

// Configuração da requisição cURL
$ch = curl_init($webhookUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($webhookData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

// Enviar a requisição
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

curl_close($ch);

// Exibir o resultado
echo "<h1>Teste de Webhook</h1>";

if ($error) {
    echo "<p style='color: red;'>Erro ao enviar webhook: $error</p>";
} else {
    echo "<p>Status da requisição: $httpCode</p>";
    echo "<p>Resposta do servidor:</p>";
    echo "<pre>" . htmlspecialchars($response) . "</pre>";
    
    // Decodificar a resposta JSON
    $responseData = json_decode($response, true);
    
    if (json_last_error() === JSON_ERROR_NONE) {
        if (isset($responseData['status']) && $responseData['status'] === 'success') {
            echo "<p style='color: green;'>Webhook enviado com sucesso!</p>";
        } else {
            echo "<p style='color: orange;'>Webhook enviado, mas com avisos: " . 
                 (isset($responseData['message']) ? $responseData['message'] : 'Sem detalhes') . "</p>";
        }
    }
}

// Exibir os dados enviados
echo "<h2>Dados enviados:</h2>";
echo "<pre>" . htmlspecialchars(json_encode($webhookData, JSON_PRETTY_PRINT)) . "</pre>";

// Adicionar link para voltar à página principal
echo "<p><a href='index.php'>Voltar para a página principal</a></p>";